/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.MilkablePacket;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.AbstractPacket;

public class RecipesEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void clickCauldron(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!Config.enableCauldronRecipes) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70093_af()) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (!InspirationsRegistry.isNormalCauldron(state)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        boolean result = TileCauldron.interact(world, pos, state, player, event.getHand());
        if (result || InspirationsRegistry.isCauldronBlacklist(stack)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void milkSquid(PlayerInteractEvent.EntityInteract event) {
        NBTTagCompound tags;
        if (!Config.milkSquids) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntitySquid)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_77973_b() == Items.field_151069_bo && (tags = target.getEntityData()).func_74765_d("milk_cooldown") == 0) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)InspirationsRecipes.dyedWaterBottle, 1, EnumDyeColor.BLACK.func_176767_b()), (int)player.field_71071_by.field_70461_c);
            player.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
            tags.func_74777_a("milk_cooldown", Config.milkSquidCooldown);
            if (!event.getWorld().field_72995_K) {
                InspirationsNetwork.sendToClients(event.getWorld(), target.func_180425_c(), (AbstractPacket)new MilkablePacket(target, false));
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

